#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
	/// <summary>
    /// Sample script demonstrating how to distinguish if an indicator plot has been set yet or not
    /// </summary>
    [Description("Sample script demonstrating how to distinguish if an indicator plot has been set yet or not")]
    public class SampleEveryNBarTest : Indicator
    {
        #region Variables
		private int n = 5; // Default setting for N
        #endregion
		
        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(Color.Orange, PlotStyle.Line, "Plot0"));
            Overlay				= false;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			/* Checks to see if the current bar has a valid indicator plot value set on indicator plot: EveryNPlot. It is important to check this to know if the values you are
			 using are relevant or not. Using irrelevant values for your script logic can cause inaccurate calculations and trade signals. */
			if(!SampleEveryNBar(N).EveryNPlot.ContainsValue(0))
			{
				// SampleEveryNBar does not have a valid indicator plot value. Set hosting indicator's plot to zero and paint the bar red.
				BarColor = Color.Red;
				Value.Set(0);
			}
			else 
			{
				// SampleEveryNBar does have a valid indicator plot value. Set hosting indicator's plot to this value and paint the bar blue.
				BarColor = Color.Blue;
				double val = SampleEveryNBar(N).EveryNPlot[0];
				Value.Set(val);
			}
        }
		
        #region Properties
        [Description("")]
        [GridCategory("Parameters")]
        public int N
        {
            get { return n; }
            set { n = Math.Max(1, value); }
        }
        #endregion
    }
}


#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private SampleEveryNBarTest[] cacheSampleEveryNBarTest = null;

        private static SampleEveryNBarTest checkSampleEveryNBarTest = new SampleEveryNBarTest();

        /// <summary>
        /// Sample script demonstrating how to distinguish if an indicator plot has been set yet or not
        /// </summary>
        /// <returns></returns>
        public SampleEveryNBarTest SampleEveryNBarTest(int n)
        {
            return SampleEveryNBarTest(Input, n);
        }

        /// <summary>
        /// Sample script demonstrating how to distinguish if an indicator plot has been set yet or not
        /// </summary>
        /// <returns></returns>
        public SampleEveryNBarTest SampleEveryNBarTest(Data.IDataSeries input, int n)
        {
            if (cacheSampleEveryNBarTest != null)
                for (int idx = 0; idx < cacheSampleEveryNBarTest.Length; idx++)
                    if (cacheSampleEveryNBarTest[idx].N == n && cacheSampleEveryNBarTest[idx].EqualsInput(input))
                        return cacheSampleEveryNBarTest[idx];

            lock (checkSampleEveryNBarTest)
            {
                checkSampleEveryNBarTest.N = n;
                n = checkSampleEveryNBarTest.N;

                if (cacheSampleEveryNBarTest != null)
                    for (int idx = 0; idx < cacheSampleEveryNBarTest.Length; idx++)
                        if (cacheSampleEveryNBarTest[idx].N == n && cacheSampleEveryNBarTest[idx].EqualsInput(input))
                            return cacheSampleEveryNBarTest[idx];

                SampleEveryNBarTest indicator = new SampleEveryNBarTest();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.N = n;
                Indicators.Add(indicator);
                indicator.SetUp();

                SampleEveryNBarTest[] tmp = new SampleEveryNBarTest[cacheSampleEveryNBarTest == null ? 1 : cacheSampleEveryNBarTest.Length + 1];
                if (cacheSampleEveryNBarTest != null)
                    cacheSampleEveryNBarTest.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheSampleEveryNBarTest = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Sample script demonstrating how to distinguish if an indicator plot has been set yet or not
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.SampleEveryNBarTest SampleEveryNBarTest(int n)
        {
            return _indicator.SampleEveryNBarTest(Input, n);
        }

        /// <summary>
        /// Sample script demonstrating how to distinguish if an indicator plot has been set yet or not
        /// </summary>
        /// <returns></returns>
        public Indicator.SampleEveryNBarTest SampleEveryNBarTest(Data.IDataSeries input, int n)
        {
            return _indicator.SampleEveryNBarTest(input, n);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Sample script demonstrating how to distinguish if an indicator plot has been set yet or not
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.SampleEveryNBarTest SampleEveryNBarTest(int n)
        {
            return _indicator.SampleEveryNBarTest(Input, n);
        }

        /// <summary>
        /// Sample script demonstrating how to distinguish if an indicator plot has been set yet or not
        /// </summary>
        /// <returns></returns>
        public Indicator.SampleEveryNBarTest SampleEveryNBarTest(Data.IDataSeries input, int n)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.SampleEveryNBarTest(input, n);
        }
    }
}
#endregion
