#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// Sample script demonstrating indicator plot set every N number of bars
    /// </summary>
    [Description("Sample script demonstrating indicator plot set every N number of bars")]
    public class SampleEveryNBar : Indicator
    {
        #region Variables
        // Wizard generated variables
            private int n = 5; // Default setting for N
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the indicator and is called once before any bar data is loaded.
        /// </summary>
        protected override void Initialize()
        {
            Add(new Plot(new Pen(Color.Yellow, 5), PlotStyle.Dot, "PlotN"));
            Overlay				= true;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
			// Sets a plot value every N number of bars. When there is no plot value set this indicator should not be accessed programmatically.
			if(CurrentBar % N == 0)
            	EveryNPlot.Set(Median[0]);
        }

        #region Properties
		/// <summary>
		/// </summary>
		[Browsable(false)]
		[XmlIgnore()]
		public DataSeries EveryNPlot
		{
			get { return Values[0]; }
		}
		
        [Description("")]
        [GridCategory("Parameters")]
        public int N
        {
            get { return n; }
            set { n = Math.Max(1, value); }
        }
        #endregion
    }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private SampleEveryNBar[] cacheSampleEveryNBar = null;

        private static SampleEveryNBar checkSampleEveryNBar = new SampleEveryNBar();

        /// <summary>
        /// Sample script demonstrating indicator plot set every N number of bars
        /// </summary>
        /// <returns></returns>
        public SampleEveryNBar SampleEveryNBar(int n)
        {
            return SampleEveryNBar(Input, n);
        }

        /// <summary>
        /// Sample script demonstrating indicator plot set every N number of bars
        /// </summary>
        /// <returns></returns>
        public SampleEveryNBar SampleEveryNBar(Data.IDataSeries input, int n)
        {
            if (cacheSampleEveryNBar != null)
                for (int idx = 0; idx < cacheSampleEveryNBar.Length; idx++)
                    if (cacheSampleEveryNBar[idx].N == n && cacheSampleEveryNBar[idx].EqualsInput(input))
                        return cacheSampleEveryNBar[idx];

            lock (checkSampleEveryNBar)
            {
                checkSampleEveryNBar.N = n;
                n = checkSampleEveryNBar.N;

                if (cacheSampleEveryNBar != null)
                    for (int idx = 0; idx < cacheSampleEveryNBar.Length; idx++)
                        if (cacheSampleEveryNBar[idx].N == n && cacheSampleEveryNBar[idx].EqualsInput(input))
                            return cacheSampleEveryNBar[idx];

                SampleEveryNBar indicator = new SampleEveryNBar();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.N = n;
                Indicators.Add(indicator);
                indicator.SetUp();

                SampleEveryNBar[] tmp = new SampleEveryNBar[cacheSampleEveryNBar == null ? 1 : cacheSampleEveryNBar.Length + 1];
                if (cacheSampleEveryNBar != null)
                    cacheSampleEveryNBar.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheSampleEveryNBar = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// Sample script demonstrating indicator plot set every N number of bars
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.SampleEveryNBar SampleEveryNBar(int n)
        {
            return _indicator.SampleEveryNBar(Input, n);
        }

        /// <summary>
        /// Sample script demonstrating indicator plot set every N number of bars
        /// </summary>
        /// <returns></returns>
        public Indicator.SampleEveryNBar SampleEveryNBar(Data.IDataSeries input, int n)
        {
            return _indicator.SampleEveryNBar(input, n);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// Sample script demonstrating indicator plot set every N number of bars
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.SampleEveryNBar SampleEveryNBar(int n)
        {
            return _indicator.SampleEveryNBar(Input, n);
        }

        /// <summary>
        /// Sample script demonstrating indicator plot set every N number of bars
        /// </summary>
        /// <returns></returns>
        public Indicator.SampleEveryNBar SampleEveryNBar(Data.IDataSeries input, int n)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.SampleEveryNBar(input, n);
        }
    }
}
#endregion
