#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Indicator;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Strategy;
#endregion

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    /// <summary>
    /// This sample demonstrates the use of the Rising and Falling conditions within the Strategy Wizard.
    /// </summary>
    [Description("This sample demonstrates the use of the Rising and Falling conditions within the Strategy Wizard.")]
    public class SampleFallingRising : Strategy
    {
        #region Variables
        // Wizard generated variables
        private int aDXPeriod = 14; // Default setting for ADXPeriod
        private int sMAPeriod = 14; // Default setting for SMAPeriod
        // User defined variables (add any user defined variables below)
        #endregion

        /// <summary>
        /// This method is used to configure the strategy and is called once before any strategy method is called.
        /// </summary>
        protected override void Initialize()
        {
            Add(ADX(ADXPeriod));
            Add(SMA(SMAPeriod));

            CalculateOnBarClose = true;
        }

        /// <summary>
        /// Called on each bar update event (incoming tick)
        /// </summary>
        protected override void OnBarUpdate()
        {
            // Condition set 1
            if (Rising(ADX(ADXPeriod)) == true
                && Rising(SMA(SMAPeriod)) == true)
            {
                EnterLong(DefaultQuantity, "");
            }

            // Condition set 2
            if (Falling(ADX(ADXPeriod)) == true)
            {
                ExitLong("", "");
            }
        }

        #region Properties
        [Description("")]
        [Category("Parameters")]
        public int ADXPeriod
        {
            get { return aDXPeriod; }
            set { aDXPeriod = Math.Max(1, value); }
        }

        [Description("")]
        [Category("Parameters")]
        public int SMAPeriod
        {
            get { return sMAPeriod; }
            set { sMAPeriod = Math.Max(1, value); }
        }
        #endregion
    }
}

#region Wizard settings, neither change nor remove
/*@
<?xml version="1.0" encoding="utf-16"?>
<NinjaTrader>
  <Name>SampleFallingRising</Name>
  <CalculateOnBarClose>True</CalculateOnBarClose>
  <Description>This sample demonstrates the use of the Rising and Falling conditions within the Strategy Wizard.</Description>
  <Parameters>
    <Parameter>
      <Default1>
      </Default1>
      <Default2>14</Default2>
      <Default3>
      </Default3>
      <Description>
      </Description>
      <Minimum>1</Minimum>
      <Name>ADXPeriod</Name>
      <Type>int</Type>
    </Parameter>
    <Parameter>
      <Default1>
      </Default1>
      <Default2>14</Default2>
      <Default3>
      </Default3>
      <Description>
      </Description>
      <Minimum>1</Minimum>
      <Name>SMAPeriod</Name>
      <Type>int</Type>
    </Parameter>
  </Parameters>
  <State>
    <CurrentState>
      <StrategyWizardState xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
        <Name>Flat</Name>
        <Sets>
          <StrategyWizardStateSet>
            <Actions>
              <StrategyWizardAction>
                <DisplayName>Enter long position</DisplayName>
                <Help />
                <MemberName>EnterLong</MemberName>
                <Parameters>
                  <string>quantity</string>
                  <string>signalName</string>
                </Parameters>
                <Values>
                  <string>DefaultQuantity</string>
                  <string />
                </Values>
                <WizardItems>
                  <StrategyWizardItem>
                    <DisplayName>DefaultQuantity</DisplayName>
                    <IsIndicator>false</IsIndicator>
                    <IsInt>true</IsInt>
                    <IsMethod>false</IsMethod>
                    <IsSet>true</IsSet>
                    <MemberName>DefaultQuantity</MemberName>
                    <Parameters />
                    <Values />
                    <WizardItems />
                  </StrategyWizardItem>
                  <StrategyWizardItem>
                    <DisplayName />
                    <IsIndicator>false</IsIndicator>
                    <IsInt>false</IsInt>
                    <IsMethod>false</IsMethod>
                    <IsSet>true</IsSet>
                    <MemberName />
                    <Parameters />
                    <Values />
                    <WizardItems />
                  </StrategyWizardItem>
                </WizardItems>
              </StrategyWizardAction>
            </Actions>
            <Conditions>
              <StrategyWizardCondition>
                <AndOr>And</AndOr>
                <Left>
                  <DisplayName>Rising</DisplayName>
                  <IsIndicator>false</IsIndicator>
                  <IsInt>false</IsInt>
                  <IsMethod>true</IsMethod>
                  <IsSet>true</IsSet>
                  <MemberName>Rising</MemberName>
                  <Parameters>
                    <string>series</string>
                  </Parameters>
                  <Values>
                    <string>ADX(ADXPeriod)</string>
                  </Values>
                  <WizardItems>
                    <StrategyWizardItem>
                      <DisplayName>ADX</DisplayName>
                      <IsIndicator>true</IsIndicator>
                      <IsInt>false</IsInt>
                      <IsMethod>true</IsMethod>
                      <IsSet>true</IsSet>
                      <MemberName>ADX</MemberName>
                      <Parameters>
                        <string>	inputSeries</string>
                        <string>Period</string>
                        <string>	plotOnChart</string>
                      </Parameters>
                      <Values>
                        <string>DefaultInput</string>
                        <string>ADXPeriod</string>
                        <string>True</string>
                      </Values>
                      <WizardItems>
                        <StrategyWizardItem>
                          <DisplayName>DefaultInput</DisplayName>
                          <IsIndicator>false</IsIndicator>
                          <IsInt>false</IsInt>
                          <IsMethod>false</IsMethod>
                          <IsSet>true</IsSet>
                          <MemberName>DefaultInput</MemberName>
                          <Parameters />
                          <Values />
                          <WizardItems />
                        </StrategyWizardItem>
                        <StrategyWizardItem>
                          <DisplayName>ADXPeriod</DisplayName>
                          <IsIndicator>false</IsIndicator>
                          <IsInt>true</IsInt>
                          <IsMethod>false</IsMethod>
                          <IsSet>true</IsSet>
                          <MemberName>ADXPeriod</MemberName>
                          <Parameters />
                          <Values />
                          <WizardItems />
                        </StrategyWizardItem>
                        <StrategyWizardItem>
                          <DisplayName />
                          <IsIndicator>false</IsIndicator>
                          <IsInt>false</IsInt>
                          <IsMethod>false</IsMethod>
                          <IsSet>true</IsSet>
                          <MemberName />
                          <Parameters />
                          <Values />
                          <WizardItems />
                        </StrategyWizardItem>
                      </WizardItems>
                    </StrategyWizardItem>
                  </WizardItems>
                </Left>
                <LookBackPeriod>1</LookBackPeriod>
                <Operator>==</Operator>
                <Right>
                  <DisplayName>True</DisplayName>
                  <IsIndicator>false</IsIndicator>
                  <IsInt>false</IsInt>
                  <IsMethod>false</IsMethod>
                  <IsSet>true</IsSet>
                  <MemberName>true</MemberName>
                  <Parameters />
                  <Values>
                    <string>true</string>
                  </Values>
                  <WizardItems>
                    <StrategyWizardItem>
                      <DisplayName />
                      <IsIndicator>false</IsIndicator>
                      <IsInt>false</IsInt>
                      <IsMethod>false</IsMethod>
                      <IsSet>true</IsSet>
                      <MemberName />
                      <Parameters />
                      <Values />
                      <WizardItems />
                    </StrategyWizardItem>
                  </WizardItems>
                </Right>
              </StrategyWizardCondition>
              <StrategyWizardCondition>
                <AndOr>And</AndOr>
                <Left>
                  <DisplayName>Rising</DisplayName>
                  <IsIndicator>false</IsIndicator>
                  <IsInt>false</IsInt>
                  <IsMethod>true</IsMethod>
                  <IsSet>true</IsSet>
                  <MemberName>Rising</MemberName>
                  <Parameters>
                    <string>series</string>
                  </Parameters>
                  <Values>
                    <string>SMA(SMAPeriod)</string>
                  </Values>
                  <WizardItems>
                    <StrategyWizardItem>
                      <DisplayName>SMA</DisplayName>
                      <IsIndicator>true</IsIndicator>
                      <IsInt>false</IsInt>
                      <IsMethod>true</IsMethod>
                      <IsSet>true</IsSet>
                      <MemberName>SMA</MemberName>
                      <Parameters>
                        <string>	inputSeries</string>
                        <string>Period</string>
                        <string>	plotOnChart</string>
                      </Parameters>
                      <Values>
                        <string>DefaultInput</string>
                        <string>SMAPeriod</string>
                        <string>True</string>
                      </Values>
                      <WizardItems>
                        <StrategyWizardItem>
                          <DisplayName>DefaultInput</DisplayName>
                          <IsIndicator>false</IsIndicator>
                          <IsInt>false</IsInt>
                          <IsMethod>false</IsMethod>
                          <IsSet>true</IsSet>
                          <MemberName>DefaultInput</MemberName>
                          <Parameters />
                          <Values />
                          <WizardItems />
                        </StrategyWizardItem>
                        <StrategyWizardItem>
                          <DisplayName>SMAPeriod</DisplayName>
                          <IsIndicator>false</IsIndicator>
                          <IsInt>true</IsInt>
                          <IsMethod>false</IsMethod>
                          <IsSet>true</IsSet>
                          <MemberName>SMAPeriod</MemberName>
                          <Parameters />
                          <Values />
                          <WizardItems />
                        </StrategyWizardItem>
                        <StrategyWizardItem>
                          <DisplayName />
                          <IsIndicator>false</IsIndicator>
                          <IsInt>false</IsInt>
                          <IsMethod>false</IsMethod>
                          <IsSet>true</IsSet>
                          <MemberName />
                          <Parameters />
                          <Values />
                          <WizardItems />
                        </StrategyWizardItem>
                      </WizardItems>
                    </StrategyWizardItem>
                  </WizardItems>
                </Left>
                <LookBackPeriod>1</LookBackPeriod>
                <Operator>==</Operator>
                <Right>
                  <DisplayName>True</DisplayName>
                  <IsIndicator>false</IsIndicator>
                  <IsInt>false</IsInt>
                  <IsMethod>false</IsMethod>
                  <IsSet>true</IsSet>
                  <MemberName>true</MemberName>
                  <Parameters />
                  <Values>
                    <string>true</string>
                  </Values>
                  <WizardItems>
                    <StrategyWizardItem>
                      <DisplayName />
                      <IsIndicator>false</IsIndicator>
                      <IsInt>false</IsInt>
                      <IsMethod>false</IsMethod>
                      <IsSet>true</IsSet>
                      <MemberName />
                      <Parameters />
                      <Values />
                      <WizardItems />
                    </StrategyWizardItem>
                  </WizardItems>
                </Right>
              </StrategyWizardCondition>
            </Conditions>
          </StrategyWizardStateSet>
          <StrategyWizardStateSet>
            <Actions>
              <StrategyWizardAction>
                <DisplayName>Exit long position</DisplayName>
                <Help />
                <MemberName>ExitLong</MemberName>
                <Parameters>
                  <string>signalName</string>
                  <string>fromEntrySignal</string>
                </Parameters>
                <Values>
                  <string />
                  <string />
                </Values>
                <WizardItems>
                  <StrategyWizardItem>
                    <DisplayName />
                    <IsIndicator>false</IsIndicator>
                    <IsInt>false</IsInt>
                    <IsMethod>false</IsMethod>
                    <IsSet>true</IsSet>
                    <MemberName />
                    <Parameters />
                    <Values />
                    <WizardItems />
                  </StrategyWizardItem>
                  <StrategyWizardItem>
                    <DisplayName />
                    <IsIndicator>false</IsIndicator>
                    <IsInt>false</IsInt>
                    <IsMethod>false</IsMethod>
                    <IsSet>true</IsSet>
                    <MemberName />
                    <Parameters />
                    <Values />
                    <WizardItems />
                  </StrategyWizardItem>
                </WizardItems>
              </StrategyWizardAction>
            </Actions>
            <Conditions>
              <StrategyWizardCondition>
                <AndOr>And</AndOr>
                <Left>
                  <DisplayName>Falling</DisplayName>
                  <IsIndicator>false</IsIndicator>
                  <IsInt>false</IsInt>
                  <IsMethod>true</IsMethod>
                  <IsSet>true</IsSet>
                  <MemberName>Falling</MemberName>
                  <Parameters>
                    <string>series</string>
                  </Parameters>
                  <Values>
                    <string>ADX(ADXPeriod)</string>
                  </Values>
                  <WizardItems>
                    <StrategyWizardItem>
                      <DisplayName>ADX</DisplayName>
                      <IsIndicator>true</IsIndicator>
                      <IsInt>false</IsInt>
                      <IsMethod>true</IsMethod>
                      <IsSet>true</IsSet>
                      <MemberName>ADX</MemberName>
                      <Parameters>
                        <string>	inputSeries</string>
                        <string>Period</string>
                        <string>	plotOnChart</string>
                      </Parameters>
                      <Values>
                        <string>DefaultInput</string>
                        <string>ADXPeriod</string>
                        <string>False</string>
                      </Values>
                      <WizardItems>
                        <StrategyWizardItem>
                          <DisplayName>DefaultInput</DisplayName>
                          <IsIndicator>false</IsIndicator>
                          <IsInt>false</IsInt>
                          <IsMethod>false</IsMethod>
                          <IsSet>true</IsSet>
                          <MemberName>DefaultInput</MemberName>
                          <Parameters />
                          <Values />
                          <WizardItems />
                        </StrategyWizardItem>
                        <StrategyWizardItem>
                          <DisplayName>ADXPeriod</DisplayName>
                          <IsIndicator>false</IsIndicator>
                          <IsInt>true</IsInt>
                          <IsMethod>false</IsMethod>
                          <IsSet>true</IsSet>
                          <MemberName>ADXPeriod</MemberName>
                          <Parameters />
                          <Values />
                          <WizardItems />
                        </StrategyWizardItem>
                        <StrategyWizardItem>
                          <DisplayName />
                          <IsIndicator>false</IsIndicator>
                          <IsInt>false</IsInt>
                          <IsMethod>false</IsMethod>
                          <IsSet>true</IsSet>
                          <MemberName />
                          <Parameters />
                          <Values />
                          <WizardItems />
                        </StrategyWizardItem>
                      </WizardItems>
                    </StrategyWizardItem>
                  </WizardItems>
                </Left>
                <LookBackPeriod>1</LookBackPeriod>
                <Operator>==</Operator>
                <Right>
                  <DisplayName>True</DisplayName>
                  <IsIndicator>false</IsIndicator>
                  <IsInt>false</IsInt>
                  <IsMethod>false</IsMethod>
                  <IsSet>true</IsSet>
                  <MemberName>true</MemberName>
                  <Parameters />
                  <Values>
                    <string>true</string>
                  </Values>
                  <WizardItems>
                    <StrategyWizardItem>
                      <DisplayName />
                      <IsIndicator>false</IsIndicator>
                      <IsInt>false</IsInt>
                      <IsMethod>false</IsMethod>
                      <IsSet>true</IsSet>
                      <MemberName />
                      <Parameters />
                      <Values />
                      <WizardItems />
                    </StrategyWizardItem>
                  </WizardItems>
                </Right>
              </StrategyWizardCondition>
            </Conditions>
          </StrategyWizardStateSet>
        </Sets>
        <StopTargets />
      </StrategyWizardState>
    </CurrentState>
  </State>
</NinjaTrader>
@*/
#endregion
